/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package rdc;

import java.io.File;

import com.inet.report.Engine;
import com.inet.report.RDC;

/**
 * This sample demonstrates how to convert a report template that was designed with Crystal Reports into an i-net Clear
 * Reports report template. If you use this sample with a Crystal Reports 9 (or higher) report template then you need to
 * execute this sample on a system on that Crystal Reports 9 (or higher) and i-net Clear Reports is installed.
 */
public class ConvertCRIntoCCReportTemplate {

    /**
     * Save a report designed with Crystal Reports in the i-net Clear Reports report file format
     */
    public ConvertCRIntoCCReportTemplate() {
        try {
            Engine eng = new Engine( Engine.NO_EXPORT );
            eng.setReportFile( "samples/sample.rpt" ); // Crystal Reports report template
            Exception[] exceptions = eng.getLoadExceptions();
            if( exceptions != null ) {
                for( int i = 0; i < exceptions.length; i++ ) {
                    System.out.println( "Exception while converting rpt file: " + (exceptions[i]).toString() + "\\n" );
                }
            }
            File file = new File( "Sample_CC.rpt" ); // i-net Clear Reports report template
            RDC.saveEngine( file, eng );
        } catch( Throwable t ) {
            t.printStackTrace();
        }
    }

    /**
     * Main method of this sample
     * @param args arguments not used
     */
    public static void main( String[] args ) {
        new ConvertCRIntoCCReportTemplate();
    }
}
